﻿package {
	import flash.events.*;
	import flash.display.*;
	import flash.geom.Rectangle;
	import flash.ui.ContextMenu;
	import flash.ui.ContextMenuItem;
	
	public class CategoriesHolder extends MovieClip{
		public var gap_vert:Number = 10;
		public var startx = 0;
		public var starty = 0;
		public var arrCategories:Array = new Array();
		public var draggingCategory:Category = null;
		public var rectCategories:Rectangle = new Rectangle();
		public var flagPlacesChanged:Boolean = false;
		public var flagDragged = false;
		public var selectedCategory:Category = null;
		public var copyMoveCategoryId:String = "";
		public var lastOverCategory:Category;		
		public var flagStageLoaded:Boolean = false;
		
		//properties on stage
		//mc_exampleCat1
		//mc_exampleCat2
		
		//constructor:
		public function CategoriesHolder(){
			this.addEventListener(MouseEvent.MOUSE_MOVE,mouseMove_handler);
			mc_exampleCat1.visible = false;
			mc_exampleCat2.visible = false;
			calcPositions();
		}
		
		//--------------------------------------------------------------------------------		
		//resets categories holder
		public function restart(){
			unselectAllCategories();
		}
		
		//--------------------------------------------------------------------------------		
		// trigger event of add category
		public function triggerAddNewCategoryEvent(){
			var catPanel = this.parent;
			catPanel.triggerAddNewCategoryEvent();
		}
		
		//--------------------------------------------------------------------------------		
		//check stage event add. add them only once.
		public function checkStageEvent(){
			if(this.flagStageLoaded == false && this.stage != null){
				this.stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpStage_handler);
				this.flagStageLoaded = true;
			}			
		}
										
		//--------------------------------------------------------------------------------		
		//hide mouse over from last category (if right clicked, and over event didn't took place
		public function hideOverBorderFromLastCategory(){
			if(this.lastOverCategory == null) return(false);
			this.lastOverCategory.hideOverBorder();
		}
		
		//--------------------------------------------------------------------------------		
		//reduce number of items from selected category.
		public function reduceSelectedCategoryNumItems(numToReduce:Number){
			if(this.selectedCategory == null) return(false);
			this.selectedCategory.reduceNumItems(numToReduce);
		}
		
		//--------------------------------------------------------------------------------		
		//reduce number of items from some category
		public function reduceCategoryNumItems(categoryID,numToReduce:Number){
			for(var i=0;i<this.arrCategories.length;i++){
				if(this.arrCategories[i].getID() == categoryID) this.arrCategories[i].reduceNumItems(numToReduce);
			}
		}
				
		//--------------------------------------------------------------------------------		
		// update data of selected category
		public function updateCategoryData(catID:String,objData:Object){
			var category = getCategoryById(catID);
			if(category == null) return(false);
			category.updateData(objData);
		}
		
		//--------------------------------------------------------------------------------		
		//calculate positions of the categories by examples.
		public function calcPositions(){
			this.startx = mc_exampleCat1.x;
			this.starty = mc_exampleCat1.y;
			this.gap_vert = mc_exampleCat2.y - mc_exampleCat1.y;
		}
		
		//--------------------------------------------------------------------------------		
		// create a new category, sets it's data and return.
		public function getCategoryWithData(xml):Category{
			var numItems:Number,order:Number;
			var category:Category = new Category();
			category.useHandCursor = true;	//show hand cursor
			
			var objData:Object = new Object();
			objData.id = xml.id.toString();
			objData.title = xml.name.toString();
			objData.type = xml.type.toString();
			objData.catDesc = xml.catDesc.toString();
			objData.longDesc = xml.longDesc.toString();
			
			numItems = Number(xml.numItems.toString());
			order = Number(xml.catOrder.toString());
			
			category.setData(objData,numItems,order);
			
						
			//set permissions
			var permission_nodelete:Boolean = Boolean(Number(xml.permission_nodelete.toString()));
			var permission_noupdate:Boolean = Boolean(Number(xml.permission_noupdate.toString()));
			var permission_noadditems:Boolean = Boolean(Number(xml.permission_noadditems.toString()));
			var hidden:Boolean = Boolean(Number(xml.hidden.toString()));
			
			category.setProperties(permission_nodelete,permission_noupdate,permission_noadditems,hidden);
			
			return(category);
		}
		
		//--------------------------------------------------------------------------------		
		// set category events
		function setCategoryEvents(cat:Category){
			cat.dispatcher.addEventListener("dragMouseDown",mouseDownCategory_handler);
			cat.dispatcher.addEventListener("dragMouseUp",mouseUpCategory_handler);
			
		}
		
		//--------------------------------------------------------------------------------		
		// set categories
		public function setCategories(xml:XMLList){
			var selectedCategoryId = getSelectedCategoryID();
			removeAllCategories();
			for(var i=0;i<xml.length();i++){
				var category:Category = getCategoryWithData(xml[i]);
				if(Number(category.getID()) != -1 && Number(category.getID()) == selectedCategoryId){
						this.selectedCategory = category;
						category.setSelected();
				}
				setCategoryEvents(category);
				this.arrCategories.push(category);
			}
			placeCategoriesToStage();
		}
		
		//--------------------------------------------------------------------------------		
		// add new category
		public function addNewCategory(xml:XMLList){			
			var category:Category = getCategoryWithData(xml);
			setCategoryEvents(category);
			this.arrCategories.push(category);
			placeCategoriesToStage();
		}
		
		//--------------------------------------------------------------------------------		
		//get category position by its id.
		public function getCategoryPosById(categoryID){
			var i:Number;
			for(i=0;i<this.arrCategories.length;i++)
				if(this.arrCategories[i].getID() == categoryID) return(i);
			return(-1);
		}
		
		//--------------------------------------------------------------------------------		
		// get category by id. if not found - return null
		public function getCategoryById(catID:String){
			var pos:Number = getCategoryPosById(catID);
			if(pos == -1) return(null);
			return(this.arrCategories[pos]);
		}
		
		//--------------------------------------------------------------------------------		
		// removes category from the list by id
		public function removeCategory(categoryID){
			var pos:Number = getCategoryPosById(categoryID);
			if(pos == -1) return(false);
			//remove category from the visible tree:
			var catToRemove:Category = this.arrCategories[pos];
			this.removeChild(catToRemove);
			//remove from array
			this.arrCategories.splice(pos,1);
			
			//destroy the object
			catToRemove = null;
			
			//reorder categories.
			placeCategoriesToStage();
			
			//select next category
			if(this.arrCategories.length > 0){
				var posNext:Number = pos;
				if(posNext >= this.arrCategories.length) posNext = this.arrCategories.length-1;
				var categoryToSelect:Category = this.arrCategories[posNext];				
				selectCategory(categoryToSelect);
			}
		}
		
		//--------------------------------------------------------------------------------		
		// remove all categories from the array and the visible stage.
		public function removeAllCategories(){
			for(var i=0;i<this.arrCategories.length;i++){
				var cat:Category = this.arrCategories[i];
				this.removeChild(cat);
			}
			this.arrCategories = new Array();
			this.selectedCategory = null;
		}
		
		//--------------------------------------------------------------------------------		
		// set categories		
		public function placeCategoriesToStage(){
			checkStageEvent();
			var i:Number,category:Category;
			var placey:Number = starty;
						
			for(i=0;i<this.arrCategories.length;i++){
				category = this.arrCategories[i];
				category.x = this.startx;
				category.y = placey;
				placey += this.gap_vert;
				category.rememberPosition();
				this.addChild(category);
			}
			setCategoriesRectangle();
		}
		
		//--------------------------------------------------------------------------------
		// find maxx and maxy of the categories, and set a rectangle around them
		public function setCategoriesRectangle(){
			var miny:Number = 1000;
			var maxy:Number = 0;
			var i:Number,category:Category;
			
			//find miny and maxy
			for(i=0;i<this.arrCategories.length;i++){
				category = this.arrCategories[i];
				if(category.y<miny) miny = category.y;
				if((category.y)>maxy) maxy = category.y;
			}
			
			this.rectCategories.left = startx;
			//this.rectCategories.right = this.width;
			this.rectCategories.right = startx;
			this.rectCategories.top = miny;
			this.rectCategories.bottom = maxy;
		}
		
		//--------------------------------------------------------------------------------		
		// get category that has been found by hittest
		function getHitCategory(x:Number,y:Number){
			if(draggingCategory == null) return(false);
			var category:Category;
			var i:Number;
			
			for(i=0;i<this.arrCategories.length;i++){
				category = this.arrCategories[i];
				if(category.name != draggingCategory.name){
					if(y>category.y && y<(category.y+category.height)) return(category);
				}
			}

			return(null)
		}
		
		//--------------------------------------------------------------------------------		
		// switch places of two categories. jump to new place only the second one.
		public function switchPlaces(category1:Category,category2:Category){						
			var cat1posx:Number,cat1posy:Number;
			var tempNumOrder:Number;
			
			cat1posx = category1.placex;
			cat1posy = category1.placey;
			category1.setPosition(category2.placex,category2.placey);
			category2.setPosition(cat1posx,cat1posy);
			category2.returnToLastPosition();
			
			//switch orders:
			tempNumOrder = category1.order;
			category1.order = category2.order;
			category2.order = tempNumOrder;
		}
		
		//--------------------------------------------------------------------------------		
		// get array of all catories order
		public function getOrderArray(){
			var arrOrders:Array = new Array();			
			var i:Number;
			
			for(i=0;i<this.arrCategories.length;i++){
				var objCatOrder:Object = new Object();
				objCatOrder.id = arrCategories[i].getID();
				objCatOrder.order = arrCategories[i].order;
				arrOrders.push(objCatOrder);
			}
			return(arrOrders);			
		}

		//--------------------------------------------------------------------------------		
		// set all categories to unselected state.
		function unselectAllCategories(){
			var i:Number;
			for(i=0;i<this.arrCategories.length;i++){
				this.arrCategories[i].setUnselected();
			}
			this.selectedCategory = null;
		}
		
		//==================== Event Handlers ========================================
				
		//--------------------------------------------------------------------------------		
		// category mouse down - start drag this category
		public function mouseDownCategory_handler(event:TextEvent){
			var categoryID = event.text;
			var category:Category = getCategoryById(categoryID);
			if(category == null) return(false);
			category.rememberPosition();
			category.startDrag(false,this.rectCategories);			
			this.draggingCategory = category;
			this.flagPlacesChanged = false;
			this.flagDragged = false;
		}
		
		//--------------------------------------------------------------------------------		
		// category mouse up - stop drag this category
		public function mouseUpCategory_handler(event:TextEvent){
		}
		
		
		//--------------------------------------------------------------------------------		
		// mouse move - if some category is dragging - check change place
		public function mouseMove_handler(event:MouseEvent){
			var hitCategory:Category;
			if(this.draggingCategory != null){
				this.flagDragged = true;
				hitCategory = getHitCategory(this.mouseX,this.mouseY);
				if(hitCategory!=null){
					switchPlaces(this.draggingCategory,hitCategory);
					this.flagPlacesChanged = true;
				}
			}
		}
		
		//--------------------------------------------------------------------------------		
		// select some category
		public function selectCategory(category){						
			//can't select category again
			if(this.selectedCategory == category) return(false);
			unselectAllCategories();
			category.setSelected();
			this.selectedCategory = category;
			var website = this.parent.parent;
			website.categorySelected_childCall(category.getID());
		}
		
		//--------------------------------------------------------------------------------		
		// get selected category
		public function getSelectedCategoryID(){
			if(this.selectedCategory == null) return(-1);
			else return(this.selectedCategory.getID());
		}		
		
		//--------------------------------------------------------------------------------		
		//get selected category object
		public function getSelectedCategory(){
			return(this.selectedCategory);
		}
		
		//--------------------------------------------------------------------------------		
		// mouse up to the stage
		public function mouseUpStage_handler(event:MouseEvent){
			if(this.draggingCategory == null) return(false);

			if(this.flagPlacesChanged == false){
				selectCategory(this.draggingCategory);
			}
			
			this.draggingCategory.stopDrag();
			this.draggingCategory.returnToLastPosition();
			this.draggingCategory = null;
			if(this.flagPlacesChanged == true){	//save categories order
				var website = this.parent.parent;
				website.saveCategoriesOrder_childCall();
			}
		}
		
		//--------------------------------------------------------------------------------		
		// get mouse over category id
		public function getMouseOverCategoryID(){
			var cat:Category;
			
			for(var i=0;i<this.arrCategories.length;i++){
				cat = this.arrCategories[i];
				if(cat.flagMouseOver == true) return(cat.getID());
			}
			return("");
		}
		
		
		//--------------------------------------------------------------------------------		
		// get last saved copy or move category id.
		public function getCopyMoveCategoryId(){
			return(this.copyMoveCategoryId);
		}
		
		//--------------------------------------------------------------------------------		
		// check if item has been dragged to category. called by the parent when stop item drag.
		public function checkItemDragToCategory(){
			var catid:String = getMouseOverCategoryID();
			if(catid == "") return(false);
			
			this.copyMoveCategoryId = catid;
			var website = this.parent.parent;
			website.showCopyMoveDialog();
		}
		
		//--------------------------------------------------------------------------------		
		// start editing the name of selected categoory
		public function editNameSelectedCategory(){
			if(this.selectedCategory == null) return(false);
			this.selectedCategory.changeToEditMode(false);
		}
		
		//--------------------------------------------------------------------------------		
		// delete selected category
		public function deleteSelectedCategory(){
			if(this.selectedCategory == null) return(false);
			this.selectedCategory.deleteCategoryRequest();
		}
		
	}
}